---
obsidianUIMode: preview
---

Sometimes all a game needs is an interesting location and some cool monsters to fight, setting up a combat encounter that a GM might build right at the table. The characters go somewhere, everyone decides it's time for a fun fight, and you whip something up. Or you determine that, given the circumstances going on in the story, it's time for the characters to run into some opposition, and you're off to the races.

Sometimes we need more, though, particularly for big set-piece battles or boss fights. When it's time to build an interesting and dynamic encounter, the following checklist can help determine what options a big combat might need:

* Interesting monsters
* A fantastic location
* Zone-wide effects
* Traps and hazards
* Advantageous positions
* Interactive objects
* Cover
* Difficult or fantastic terrain
* A goal

No battle needs all these things, but it's worth running through the list to see which options fit the sort of combat scenario you're putting together.

## Interesting Monsters

For a big, self-contained combat encounter, a single monster usually won't do it. Even several monsters of the same type might not prove interesting enough for a big fight. Complex, climactic battles often work best with two or three creature types that work well together—big bruisers up front and powerful artillery in the back, for example.However, having more than three types of creatures in any one battle is going to be hard to manage. As such, designing a big set-piece battle is also a great time to think about waves of monsters.

## A Fantastic Location

An empty, 50-foot-square room doesn't lend itself to an interesting set-piece battle. We want fantastic rooms with interesting shapes, lots of room to move around, and a cool environment for the characters to spend time in. Great self-contained fights are like theme parks where the characters can climb up big statues, swing from chandeliers, and dance across elevated platforms. Whether you're playing online or in person, you can purchase battle maps showing off interesting locations, or might find maps that cartographers have released for free. Build a library of cool maps that inspire your players to enjoy the scenery while they're kicking ass.

However, you want to ensure that your fantastic location isn't too big. It's no fun to have a character spend multiple rounds running to the far side of an arena—only to arrive just in time to watch the other characters drop the big bad to the mat. Let all the characters get to the meaty part of a location in two moves at most.

## Zone-Wide Effects

Sometimes a combat environment has a big ongoing effect—something that impacts all the creatures in the area, no matter where they are. Such zone-wide effects can make a fight more interesting, as with any of the following examples:

* Unholy energy in a crypt makes healing magic only half as effective as normal.
* Supernatural fire negates any creature's resistance to fire, and turns immunity to fire into resistance.
* Psychic wailing forces each character to succeed on a DC 10 Constitution check to successfully cast a spell.
* Periodic bolts of lightning strike, with each creature in combat having a 1-in-4 chance of being struck at the start of their turn.
* An arcane rift causes each damaging spell cast in a fight to deal an extra 2d6 force damage.
* An aura of bloody rage fills the area, granting each combatant advantage on attack rolls.
* A rift to a realm of chaos causes all spells to trigger a wild magic surge.
* The god of blood infuses all melee attacks with an extra die of damage.
* A rift in space-time lets a creature swap places with an enemy within 60 feet if that enemy fails a DC 12 Wisdom saving throw.
* A thick fog makes it impossible to see creatures more than 30 feet away.

Avoid zone-wide effects that are just plain annoying. Having creatures fall down a lot because of icy floors sounds fun—until all the characters are lying on their backs and the players are wishing they'd never entered the fight in the first place.

Likewise, certain effects hurt some classes more than others. Disadvantage on attack rolls hurts martial combatants more than spellcasters. Limiting movement hurts melee attackers, while limiting visibility hurts ranged attackers. Be aware of when a zone-wide effect affects some characters more than others, so that you can change it up if needed.

## Traps and Hazards

Certain parts of a battlefield might contain traps or hazards. Some of these might be easily seen, such as bladed pillars or spike-lined pits. Others might come as a surprise, such as a trap door over an acid pool.

Characters with high passive Wisdom (Perception) scores might notice hidden traps automatically, or you might give each character a chance to make a Wisdom (Perception) check requiring no action—maybe even rolling on their behalf—to detect a trap before stumbling into it.

Make sure these traps matter if you're going to put them in an encounter. Traps that are too far out of the way might never come into play. Likewise, it can be fun for players to spring traps on their opponents, so don't use them only as a threat against the characters.

## Advantageous Positions

Getting the characters to enter an arena (literal or metaphorical) and move around can be hard. Advantageous positions give them a reason to do so. Areas of high ground where they can gain cover against their foes—and perhaps advantage on attacks—are highly sought after by ranged attackers. Arcane circles that infuse a spellcaster's magic with greater power might draw wizards into a room. This approach can turn a whole encounter into a fun game of "king of the hill" as the characters and their enemies fight for superior position.

## Interactive Objects

Make sure that the battlefield features some interactive objects. This can include any physical features the characters can manipulate and use to their advantage in a fight, including things like the following:

* Crumbling statues that can be easily toppled
* Pillars that collapse part of the ceiling
* Chandeliers upon which to swing
* Ballistas the characters can use to fire upon their foes
* Obelisks infusing the villain with power until they're destroyed
* Levers that physically or magically transform parts of the battlefield
* Catapults that can hurl allies to the far side of the fight
* Cranes lifting heavy objects that can be dropped onto foes
* Fiery cauldrons or braziers ready to tip over
* Deep wells into which enemies can be dumped

## Cover

Shattered pillars, crumbling statues, destroyed furniture, fallen trees, and other forms of cover can help break up the otherwise open terrain of a big battleground. When you drop in these elements of cover, be sure that the players understand the advantages of hiding behind them.

For bonus points, tie the history of the location and other secrets and clues to these elements of cover. It's not just a statue—it's a statue of the forgotten god Gan, lost in history and now seeking just one follower to pull their spark of divinity from the edges of infinite darkness.

## Difficult or Fantastic Terrain

Different areas of a location might have some sort of terrain feature that can impact the fight. Difficult terrain is the easiest option, making it challenging but not impossible to take certain routes across the battlefield. But other areas of interesting terrain can also shake up a physical encounter. Icy floors where the characters might slip don't work well as a zone-wide effect. But they can be great in specific areas, forcing the characters to avoid those areas as they move.

Any of the following terrain features can make a big battle location more interesting:

* A crumbling bridge over a deep crevasse
* Spikes of sharp glass that cut creatures when they fall or are forced to move through them
* Jets of flame that randomly erupt
* Swampy land that belches forth poisonous gas when crossed
* Oiled surfaces that cause creatures to slide across them uncontrollably.
* Electrified floors that deal damage to creatures at the start of each turn
* An area filled with antigravity magic that causes creatures to fall to the ceiling
* An ethereal rift where creatures become invisible and insubstantial
* Pockets of shadow where characters have their life energy drained away
* An area of antilife magic where living creatures gain vulnerability to necrotic damage

## A Goal

Finally, think about what objective an encounter might have beyond simply taking out all the enemies. What might the characters do to "complete" the encounter? The following sorts of goals work well in a big set-piece encounter:

* Stop a ritual before cultists summon a demon.
* Recover an artifact and escape with it.
* Kill the boss, but don't worry about their minions.
* Activate a gateway and escape through it.
* Recover a prisoner.
* Steal secret plans.
* Destroy a powerful monument.
* Activate the four altars around a temple site.
* Close a magical gateway and prevent the villain's escape.
* Destroy a doomsday device before it blows up the multiverse.
